/*****************************************************************************************
* MERGING INDIVIDUAL FILES ACROSS WAVES INTO LONG FORMAT                                 *
* To match individual level files across two waves into a long format                    *
* do the following (for more waves add wave specific prefix in the foreach statement)    *
*****************************************************************************************/

// change current file location
cd "location:/for/files/you/create"

// assign global macro to refer to Understanding Society data
global ukhls "location:/ukhls/datafiles/are/stored"

//loop through each wave
foreach w in a b c d e f g { // For fewer waves use only the wave prefix of the waves you need to merge
	
	// find the wave number
	local waveno=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
	
	// open the individual level file
	use pidp `w'_jbhas using "$ukhls/ukhls_w`waveno'/`w'_indresp", clear
	
	// drop the wave prefix from all variables
	rename `w'_* *
	
	// create a wave variable
	gen wave=`waveno'
	
	// save one file for each wave
	save temp`w', replace
}

// open the file for the first wave (wave a_)
use tempa, clear

// loop through the remaining waves
foreach w in b c d e f g {

	// append the files for the second wave onwards
	append using temp`w'
}

// check how many observations are available from each wave
tab wave

// save the long file
save longfile, replace

// erase temporary files
foreach w in a b c d e f g {
	erase temp`w'.dta
}
